<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\PrestaShopProxyController;
use App\Http\Controllers\Api\StatsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Fichier à placer dans routes/api.php
|
*/

// Route de santé (publique)
Route::get('/health', function () {
    return response()->json([
        'status' => 'ok',
        'version' => '1.0.0',
        'timestamp' => now()->toIso8601String(),
    ]);
});

// ============================================
// Authentification (publique)
// ============================================
Route::prefix('auth')->group(function () {
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);
    
    // Routes protégées par Sanctum
    Route::middleware('auth:sanctum')->group(function () {
        Route::post('/logout', [AuthController::class, 'logout']);
        Route::get('/me', [AuthController::class, 'me']);
    });
});

// ============================================
// Routes protégées (authentification requise)
// ============================================
Route::middleware('auth:sanctum')->group(function () {
    
    // ============================================
    // PrestaShop Proxy (sécurise le WS_KEY)
    // ============================================
    Route::prefix('prestashop')->group(function () {
        // Proxy générique
        Route::post('/proxy', [PrestaShopProxyController::class, 'proxy']);
        
        // Endpoints spécifiques
        Route::get('/products', [PrestaShopProxyController::class, 'getProducts']);
        Route::get('/categories', [PrestaShopProxyController::class, 'getCategories']);
        
        // Admin uniquement : modification de produits
        Route::middleware('can:admin')->group(function () {
            Route::post('/products', [PrestaShopProxyController::class, 'updateProduct']);
            Route::put('/products/{id}', [PrestaShopProxyController::class, 'updateProduct']);
        });
    });
    
    // ============================================
    // Statistiques
    // ============================================
    Route::prefix('stats')->group(function () {
        Route::get('/', [StatsController::class, 'getStats']);
        Route::get('/kpis', [StatsController::class, 'getKpis']);
        
        // Admin uniquement : vider le cache
        Route::middleware('can:admin')->group(function () {
            Route::post('/clear-cache', [StatsController::class, 'clearCache']);
        });
    });
});

// ============================================
// Route 404 pour API
// ============================================
Route::fallback(function () {
    return response()->json([
        'success' => false,
        'error' => 'Endpoint non trouvé',
    ], 404);
});
